import java.util.Scanner;

public class Listing12_7
{
   public static void main(String[] args)
   {
      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);
      
      // Deklarujemy zmienną, w której zapiszemy numer telefonu
      String phoneNumber;
      
      // Prosimy użytkownika o wprowadzenie numeru telefonu
      System.out.println("Wprowadź niesformatowany numer telefonu składający się z 10 cyfr.");
      phoneNumber = keyboard.nextLine();
    
      // Jeśli wprowadzony łańcuch znakowy składa się z 10 znaków, formatujemy go
      if (phoneNumber.length() == 10)
      {
         System.out.println("Sformatowany numer telefonu: " + format(phoneNumber));
      }
      else
      {
         System.out.println("Numer nie składa się z 10 cyfr.");
      }
   }
   
   // Metoda format module przyjmuje jako argument łańcuch znakowy
   // Zakładamy, że łańcuch znakowy to niesformatowany 10-cyfrowy numer telefonu
   // Metoda formatuje łańcuch znakowy
   // w następujący sposób: (XXX)XXX-XXXX
   // i go zwraca
   public static String format(String str)
   {
      // Zapisujemy łańcuch znakowy str w obiekcie StringBuilder
      StringBuilder strb = new StringBuilder(str);
		
      // Najpierw na pozycji 0 wstawiamy lewy nawias
      strb.insert(0, "(");
		
      // Następnie na pozycji 4 wstawiamy prawy nawias
      strb.insert(4, ")");
      
      // Następnie na pozycji 8 wstawiamy łącznik
      strb.insert(8, "-");
		
      // Zwracamy łańcych znakowy zapisany  
      // w obiekcie StringBuilder
      return strb.toString();
   }
}
